#!/bin/sh
#
# Copyright (c) 2009 Avira GmbH
# Post install script. This script creates the symlinks to all libraries required for the product to start
#

if [ ! -z "$1" -a -d "$1" ]
then
	AVDIR="$1"
else
	AVDIR="/usr/lib/AntiVir"
fi

for LIB_NAME in `ls $AVDIR/lib*.so* | sed -e 's/\.so.*/.so/g'| sort -u`
do
	LIB_FILE=`ls ${LIB_NAME}?* 2> /dev/null | sort -n | tail -1`
	if [ -n "$LIB_FILE" ]
	then
		if [ -L "$LIB_NAME" ]
		then
			rm "$LIB_NAME"
			rm "$LIB_NAME.0"
		fi

		ln -s "$LIB_FILE" "$LIB_NAME"
		ln -s "$LIB_FILE" "$LIB_NAME.0"
	fi
done
