#!/bin/sh
#
# Copyright (c) 2009 Avira GmbH
#

if [ ! -z "$1" -a -d "$1" ]
then
	AVDIR="$1"
else
	AVDIR="/usr/lib/AntiVir"
fi

CONFFILE_LIST="/etc/avira/avguard-scanner.conf \
               /etc/avmailgate-scanner.conf \
               /etc/avwebgate-scanner.conf"
OS=`uname | env LANG=C LC_ALL=C LC_CTYPE=C tr '[:upper:]' '[:lower:]'`
SAVAPITIMEOUT="40"
SAVAPI_OK="0"

case "${OS}" in
	sunos)
		PSAX="ps -Af"
		;;
	freebsd)
		PSAX="ps ax"
		;;
	darwin)
		PSAX="ps ax"
		;;
	*)
		PSAX="ps ax"
		;;
esac

sh $AVDIR/post_install.sh $AVDIR

for ITEM in `echo $CONFFILE_LIST`
do
	if [ -f $ITEM ]
	then
		if [ "$ITEM" = "/etc/avira/avguard-scanner.conf" ]
		then
			if [ -x $AVDIR/avguard.bin ]
			then
				$AVDIR/avguard.bin --status > /dev/null 2>&1
				ERR="$?"
				case $ERR in
					0)
						if $PSAX | grep avguard.bin | grep "\-\-server" > /dev/null 2>&1
						then
							GUARD_PARAM="--server"

						elif $PSAX | grep avguard.bin | grep "\-\-workstation" > /dev/null 2>&1
						then
							GUARD_PARAM="--workstation"

						else
							GUARD_PARAM="--workstation"
						fi

						echo "Restarting AntiVir: scanner"
						${AVDIR}/avguard.bin $GUARD_PARAM --restart
						if [ $? -ne 0 ]
						then
							echo "It was not possible to start savapi3"
							exit 1
						fi
			
						sleep 5
						;;
			
					1)
						# no savapi is running, continue with the other conf file
						;;
			
					*)
						echo "An error occurred in SAVAPI, please check the logfile"
						exit 1
						;;
				esac
			fi
		else
			if [ -x $AVDIR/savapi ]
			then
				$AVDIR/savapi --status --config=$ITEM > /dev/null
				ERR="$?"
				case $ERR in
					0)
						echo "Restarting AntiVir: scanner"
						$AVDIR/savapi --config=$ITEM --allow-remote-shutdown
						if [ $? -ne 0 ]
						then
							echo "It was not possible to start savapi3"
							exit 1
						fi
	
						while [ "$SAVAPITIMEOUT" -gt 0 -a "$SAVAPI_OK" -eq 0 ]
						do
							$AVDIR/savapi --status --config=$ITEM > /dev/null 2>&1
							if [ "$?" -eq 0 ]
							then
								SAVAPI_OK=1
							fi
					
							sleep 1
							SAVAPITIMEOUT=`expr ${SAVAPITIMEOUT} - 1`
						done
						;;
		
					218)
						echo "error: SAVAPI Timeout reached"
						exit 1
						;;
			
					219)
						if [ -x "${AVDIR}/avmailgate" ]
						then
							ls /var/run/avmailgate/scanner > /dev/null 2>&1
							ERR_SAVAPI_SOCKET="$?"
							if [ "$ERR_SAVAPI_SOCKET" -eq "0" ]
							then
								echo "Restarting AntiVir: mailgate"
								${AVDIR}/avmailgate restart
								if [ $? -ne 0 ]
								then
									echo "It was not possible to start savapi3"
									exit 1
								fi
							fi

						elif [ -x "${AVDIR}/avwebgate" ]
						then
							ls /var/run/avwebgate/scanner > /dev/null 2>&1
							ERR_SAVAPI_SOCKET="$?"
							if [ "$ERR_SAVAPI_SOCKET" -eq "0" ]
							then
								echo "Restarting AntiVir: webgate"
								${AVDIR}/avwebgate restart
								if [ $? -ne 0 ]
								then
									echo "It was not possible to start savapi3"
									exit 1
								fi
							fi
						fi
						;;
			
					*)
						echo "An error occurred in SAVAPI, please check the logfile"
						exit 1
						;;
				esac
			fi
		fi
	fi
done

