#!/bin/sh
#
# Copyright (c) 2009 Avira GmbH
#

if [ ! -z "$1" -a -d "$1" ]
then
	AVDIR="$1"
else
	AVDIR="/usr/lib/AntiVir"
fi

CONFFILE_LIST="/etc/avira/avguard-scanner.conf \
               /etc/avmailgate-scanner.conf \
               /etc/avwebgate-scanner.conf"
SAVAPITIMEOUT="40"
SAVAPI_OK="0"
OS=`uname | env LANG=C LC_ALL=C LC_CTYPE=C tr '[:upper:]' '[:lower:]'`

for ITEM in `echo $CONFFILE_LIST`
do
	if [ -f $ITEM ]
	then
		if [ "$ITEM" = "/etc/avira/avguard-scanner.conf" ]
		then
			if [ -x $AVDIR/avguard.bin ]
			then
				$AVDIR/avguard.bin --status > /dev/null 2>&1
				ERR="$?"
				case $ERR in
					0)
						${AVDIR}/avguard.bin --reload-engine
						if [ $? -ne 0 ]
						then
							echo "It was not possible to start savapi3"
							exit 1
						fi
			
						sleep 5
						;;
			
					1)
						# no savapi is running, continue with the other conf file
						;;
			
					*)
						echo "An error occurred in SAVAPI, please check the logfile"
						exit 1
						;;
				esac
			fi
		else
			if [ -x $AVDIR/savapi ]
			then
				$AVDIR/savapi --status --config=$ITEM > /dev/null
				ERR="$?"
				case $ERR in
					0)
						echo "Reloading AntiVir: scanner"
						$AVDIR/savapi --reload-engine --config=$ITEM --allow-remote-shutdown
						
						if [ "${OS}" = "sunos" ]
						then
							sleep 20
						else
							sleep 2
						fi

						$AVDIR/savapi --status --config=$ITEM > /dev/null 2>&1
						if [ "$?" -eq 219 ]
						then
							echo "Restarting AntiVir: scanner"
							$AVDIR/savapi --config=$ITEM --allow-remote-shutdown
							if [ $? -ne 0 ]
							then
								echo "It was not possible to start savapi3"
								exit 1
							fi
						else
							$AVDIR/savapi --version > /dev/null 2>&1
							if [ "$?" -ne "101" ]
							then
								echo "It was not possible to load the new engine"
								exit 1
							fi
						fi
	
						while [ "$SAVAPITIMEOUT" -gt 0 -a "$SAVAPI_OK" -eq 0 ]
						do
							$AVDIR/savapi --status --config=$ITEM > /dev/null 2>&1
							if [ "$?" -eq 0 ]
							then
								SAVAPI_OK=1
							fi
					
							sleep 1
							SAVAPITIMEOUT=`expr ${SAVAPITIMEOUT} - 1`
						done
						;;
		
					218)
						echo "error: SAVAPI Timeout reached"
						exit 1
						;;
		
					219)
						if [ -x "${AVDIR}/avmailgate" ]
						then
							ls /var/run/avmailgate/scanner > /dev/null 2>&1
							ERR_SAVAPI_SOCKET="$?"
							if [ "$ERR_SAVAPI_SOCKET" -eq "0" ]
							then
								echo "Restarting AntiVir: mailgate"
								${AVDIR}/avmailgate restart
								if [ $? -ne 0 ]
								then
									echo "It was not possible to start savapi3"
									exit 1
								fi
							fi

						elif [ -x "${AVDIR}/avwebgate" ]
						then
							ls /var/run/avwebgate/scanner > /dev/null 2>&1
							ERR_SAVAPI_SOCKET="$?"
							if [ "$ERR_SAVAPI_SOCKET" -eq "0" ]
							then
								echo "Restarting AntiVir: webgate"
								${AVDIR}/avwebgate restart
								if [ $? -ne 0 ]
								then
									echo "It was not possible to start savapi3"
									exit 1
								fi
							fi
						fi
						;;
		
					*)
						echo "An error occurred in SAVAPI, please check the logfile"
						exit 1
						;;
				esac
			fi
		fi
	fi
done