#!/bin/sh
#
# Uninstall AntiVir for UNIX
#
# Copyright (c) 2009 AVIRA GmbH
#

OS=`uname | env LANG=C LC_ALL=C LC_CTYPE=C tr '[:upper:]' '[:lower:]'`

AVDIR="/usr/lib/AntiVir"
BACKUP_NAME="avira"
BACKUPDIR="/var/backups/${BACKUP_NAME}"
SET_LIBRARY_PATH=""

case "${OS}" in
	sunos)
		PROCCMD="ps -ef"
		PROCCMD="ps -ef -o pid,comm"
		ECHO="echo"
		RM_DIR="-r"
		SET_LIBRARY_PATH="env LD_LIBRARY_PATH="/usr/local/lib:/usr/lib/AntiVir/agent""
		
		;;
	*)
		PROCCMD="ps axw"
		PROCCMD="ps axw -o pid,command"
		ECHO="echo"
		RM_DIR="-rd"
		;;
esac


testPROCCMD()
{
	$PROCCMD > /dev/null 2>&1
}


getPROCESSLIST()
{
	PROCESSLIST=""

	if [ -z "$PROCCMD" ]
	then
		testPROCCMD
		if [ "$?" -ne 0 ]
		then
			PROCCMD="ps -A -o pid,args"
			testPROCCMD
		fi
	fi

	for PROC in `$PROCCMD | grep "$1" | grep -v uninstall | grep -v grep`
	do
		if [ -z "`${ECHO} ${PROC} | sed -e s/[0-9]//g`" ]
		then
			PROCESSLIST="${PROCESSLIST} ${PROC}"
		fi
	done
}


uninstall_plugin()
{
	${SET_LIBRARY_PATH} ${AVDIR}/agent/agent --uninstall-plugin ${PLUGIN_NAME} > /dev/null 2>&1

	grep "${PLUGIN_NAME}" /etc/avira/agent.ini > /dev/null 2>&1
	if [ "${?}" -eq 0 ]
	then
		/bin/sh ${AVDIR}/agent/smc-agent stop > /dev/null 2>&1
		if [ ${?} -ne 0 ]
		then
			getPROCESSLIST "agent"
			kill -9 ${PROCESSLIST}
		fi
		
		cp /etc/avira/agent.ini /etc/avira/agent.ini.orig
		cat /etc/avira/agent.ini.orig | grep -v ${PLUGIN_NAME}=${AVDIR}/agent/${ITEM} > /etc/avira/agent.ini
		rm /etc/avira/agent.ini.orig
		
		/bin/sh ${AVDIR}/agent/smc-agent start > /dev/null 2>&1
	fi

	return 0
}



# main
	for ITEM in $@
	do
		PLUGIN_NAME=`${ECHO} ${AVDIR}/agent/${ITEM} | sed -e "s/^.*ux/ux/; s/\.so$//"`
		uninstall_plugin
	done
	
	exit 0

