#!/bin/sh
#
# chkconfig: 3 90 08
# description: ProScan Anti-Virus for Mailserver
PROSCAN_BIN=/opt/proscan/bin/proscan

milter_start() {
    ##add_start
    true
}

milter_stop() {
    ##add_stop
    true
}

start() {
  if [ -x $PROSCAN_BIN ]; then
      milter_start
      $PROSCAN_BIN > /dev/null 2>&1
       if [ $? -eq 0 ]; then
          echo "ProScan was started"
        else 
          echo "ProScan couldn't be started"
      fi
  else 
      echo "$PROSCAN_BIN was not found"
      exit 2
  fi  
  
}
stop() {
  milter_stop
  if [ -x $PROSCAN_BIN ]; then
      $PROSCAN_BIN stop  > /dev/null 2>&1
      if [ $? -eq 0 ]; then
          echo "ProScan was stoped"
          return 0
      else
          echo "ProScan couldn't be stoped" 
      fi
  else 
      echo "$PROSCAN_BIN was not found"
      exit 2
  fi  
}

status() {
  PS=`ps ax |grep $PROSCAN_BIN |grep -v grep`
  if [ -n "$PS" ]; then 
      echo "ProScan is  running"
    else
      echo "ProScan is not running"
  fi	  
}

restart() {
  stop
  sleep 1
  start
}

case $1 in 
	start)
		start
		;;
	stop)
		stop
		;;
	status)
		status
		;;
	restart)
		restart
		;;
	*)
		echo "Usage: ${0##*/} {start|stop|restart|status}"
		;;
esac

exit 0
