#!/bin/sh
#
# Copyright (c) 2009 AVIRA GmbH
# Copyright (C) 2010 Promark, Inc.
#
# This script updates installed AVIRA products and their components

OS=`uname | env LANG=C LC_ALL=C LC_CTYPE=C tr '[:upper:]' '[:lower:]'`
case "${OS}" in
	linux)
		CLASS='linux_glibc22'
		PS="ps ax"
		;;
	sunos)
		CLASS='solaris_sparc'
		PS="ps -ef"
		;;
	freebsd)
		CLASS='freebsd'
		PS="ps -ax"
		;;
	*)
		echo 'Platform not supported'
		exit 2
		;;
esac

update_prod ()
{
	PRODUCT='savapi3'
	PRODUCT_FILE="/update/idx/${PRODUCT}-${CLASS}-en.idx"
	PRODUCT_INFO_FILE="/update/idx/${PRODUCT}-${CLASS}-en.info.gz"

	echo 'Updating, please wait...'
	$AVDIR/avupdate.bin $CONFIG $CHECK --product-file=${PRODUCT_FILE} --product-info-file=${PRODUCT_INFO_FILE} ${MODULES_LIST} --skip-master-file $LICENSE_CHECK ${UNKNOWN_AVUPDATE_PARAMETER}
	UPDATE_ERR="$?"
}

# main
AVDIR='/usr/lib/AntiVir'
if [ ! -x "$AVDIR/avupdate.bin" ]
then
	echo ''
	echo "Cannot execute $AVDIR/avupdate.bin"
	exit 2
fi

INSTALLED_PRODUCTS=''
if [ -x "$AVDIR/savapi" -o -x "$AVDIR/aeset.dat" ]
then
	INSTALLED_PRODUCTS="$INSTALLED_PRODUCTS Scanner"
fi
if [ "$INSTALLED_PRODUCTS" = '' ]
then
	echo 'No AVIRA products installed'
	exit 2
fi

if [ -z "$1" ]
then
	echo 'No product specified'
	exit 2
fi

CHECK=''
CONFIG='--config=/etc/avira/avupdate.conf'
PRODUCT=''
LICENSE_CHECK='--check-product'
UNKNOWN_AVUPDATE_PARAMETER=""
UPDATE_WEBCAT="0"
PROD_FOUND="0"
PROD_SPECIFIED="0"
UPDATE_ERR="0"
SAVAPITIMEOUT="40"
SAVAPI_OK="0"

for PARAM in "$@"
do
	case ${PARAM} in
		--product=*)
			if [ "$PROD_SPECIFIED" -eq 1 ]
			then
				echo 'Cannot update more than one product at once'
				display_help
				exit 2
			fi
			PRODUCT=`echo $PARAM | cut -d'=' -f2 | dd conv=lcase 2>/dev/null`
			PROD_SPECIFIED="1"

			# check if update is for installed product
			if [ "$PRODUCT" = "engine" -o "$PRODUCT" = "signatures" ]
			then
				PRODUCT="scanner"
			fi

			for ITEM in `echo $INSTALLED_PRODUCTS | dd conv=lcase 2>/dev/null`
			do
		        	if [ "$PRODUCT" = "$ITEM" ]
				then
		        	        PROD_FOUND=1
        			fi
			done
			if [ $PROD_FOUND -eq 0 ]
			then
				echo "Product" `echo $PARAM | cut -d'=' -f2` "not installed or invalid product specified"
				exit 2
			fi
			;;

		--config=*)
			CONF_LOCATION=`echo $PARAM | cut -d '=' -f2`
			# check for valid configuration file
			if [ ! -f "$CONF_LOCATION" ]
			then
				echo 
				echo "$CONF_LOCATION not found"
				exit 2
			fi
			CONFIG=$PARAM
			;;

		-c|--check)
			CHECK='--check-if-update-available'
			;;

		-v|--version)
			$AVDIR/avupdate.bin --version
			exit 0
			;;

		*)
			echo "unkown script parameter found. the parameter will be used for direct avupdate.bin start ... "
			UNKNOWN_AVUPDATE_PARAMETER="${PARAM} ${UNKNOWN_AVUPDATE_PARAMETER}"
			;;
	esac
done

if [ $PROD_SPECIFIED -eq 1 ]
then
	update_prod
	if [ $UPDATE_ERR -eq 0 ]
	then
		if [ -x $AVDIR/savapi ]
		then
			SAVAPI_PARAM=`$PS | grep socket-file | grep -v grep | awk '{print $6, $7, $8}'`
			$AVDIR/savapi --status $SAVAPI_PARAM > /dev/null
			ERR="$?"
			case $ERR in
				0)
					echo "Reloading AntiVir: savapi"
					$AVDIR/savapi --reload-engine $SAVAPI_PARAM
					if [ "${OS}" = "sunos" ]
					then
						sleep 20
					else
						sleep 2
					fi
					$AVDIR/savapi --status $SAVAPI_PARAM > /dev/null 2>&1
					if [ "$?" -eq 219 ]
					then
						echo "Restarting AntiVir: savapi"
						$AVDIR/savapi $SAVAPI_PARAM
						if [ $? -ne 0 ]
						then
							echo "It was not possible to start savapi3"
							exit 1
						fi
					else
						$AVDIR/savapi --version > /dev/null 2>&1
						if [ "$?" -ne "101" ]
						then
							echo "It was not possible to load the new engine"
							exit 1
						fi
					fi
					
					while [ "$SAVAPITIMEOUT" -gt 0 -a "$SAVAPI_OK" -eq 0 ]
					do
						$AVDIR/savapi --status $SAVAPI_PARAM > /dev/null 2>&1
						if [ "$?" -eq 0 ]
						then
							SAVAPI_OK=1
						fi
						
						sleep 1
						SAVAPITIMEOUT=`expr ${SAVAPITIMEOUT} - 1`
					done
					;;
				
				218)
					echo "error: SAVAPI Timeout reached"
					exit 1
					;;
				
				219)
					echo "SAVAPI not running"
					exit 0
					;;
				
				*)
					echo "An error occurred in SAVAPI, please check the logfile (code=$ERR)"
					exit 1
					;;
			esac
		fi
	elif [ $UPDATE_ERR -eq 1 ]
	then
  		UPDATE_ERR=0
	fi
else
	echo 'No product specified'
	UPDATE_ERR=2
fi

exit "$UPDATE_ERR"
