#!/bin/sh
#--------------------------------------
# proscanlm super visor for Linux
#--------------------------------------
SOCKFILE=/var/run/proscan.sock
PIRIOD=10
OS=`uname`

case "$OS" in
Linux)
    PROSCANLM=/opt/proscan/bin/proscanlm
    PS="ps -ef"
    STAT=stat
    ;;
*)
    echo "$OS no supported"
    exit
    ;;
esac

if [ "$OS" = "Linux" ]
then
    PIDLIST=`$PS | grep $PROSCANLM | grep -v grep | awk '{print $2 ":" $3}'`
    if [ "$PIDLIST" = "" ]
    then
        echo "proscanlm pid not found"
        exit 1
    fi
    
    for PID in $PIDLIST
    do
        CHK=`echo $PID | egrep ":1$"`
        if [ "$CHK" != "" ]
        then
            PID=`echo $PID|awk -F: '{print $1}'`
            break
        fi
    done
elif [ "$OS" = "SunOS" ]
then
    PID=`$PS | grep $PROSCANLM | grep -v grep | awk '{print $2; exit;}'`
else
    PID=`$PS | grep $PROSCANLM | grep -v grep | awk '{print $1; exit;}'`
fi

N=0
CHKFILE=/proc/$PID/$STAT
OWNER=`ls -l $SOCKFILE|awk '{print $3}'`

echo $$ > /var/run/proscancheck.pid

while(true)
do
if [ ! -e "$SOCKFILE" -o ! -e "$CHKFILE" ]
then
    if [ -e $SOCKFILE ]
    then
        rm -f $SOCKFILE
    fi
    $PROSCANLM
    sleep 5
    chown $OWNER:$OWNER $SOCKFILE
    N=`expr $N + 1`
fi
if [ $N -gt 5 ]
then
    echo "proscanlm could not start..."
    exit 1
fi
sleep $PIRIOD
if [ $N != 0 ]
then
  if [ "$OS" = "Linux" ]
  then
    PIDLIST=`$PS | grep $PROSCANLM | grep -v grep | awk '{print $2 ":" $3}'`
    if [ "$PIDLIST" != "" ]
    then
        for PID in $PIDLIST
        do
            CHK=`echo $PID | egrep ":1$"`
            if [ "$CHK" != "" ]
            then
                PID=`echo $PID|awk -F: '{print $1}'`
                break
            fi
        done
    fi
  elif [ "$OS" = "SunOS" ]
  then
    PID=`$PS | grep $PROSCANLM | grep -v grep | awk '{print $2}'`
  else
    PID=`$PS | grep $PROSCANLM | grep -v grep | awk '{print $1}'`
  fi
  
  N=0
  CHKFILE=/proc/$PID/$STAT
fi
done
