#!/bin/sh
#An e-mail address where updating results will be sent
ADMIN_ADDRESS="postmaster"

#Specify when should the administrator be notified by the update process
VERBOSE="silent"
#VERBOSE="noisy"
#VERBOSE="errors"

# end of configurable area
#
#--------------------------------------------------------------

#Path to the update program
BINDIR="/opt/proscan"
DATADIR="/var/opt/proscan"
EXECUTABLE="/usr/lib/AntiVir/savapi"
VERSION_OPT="--version"
PROSCANUPDATE="${BINDIR}/bin/proscanup -V -u root"

#Name of ProScan AntiVirus scanning process
MAIL=`which mail`
if [ -z "$MAIL" ]; then 
    MAIL=`which mailx`
    if [ -z "$MAIL" ]; then
        MAIL=`which Mail`
        if [ -z "$MAIL" ]; then
            echo "ERROR: no 'mail' utility found in system..."
	    exit
        fi 
    fi
fi 

#Reroute error messages to heaven
exec 2>/dev/null

vdf_update_ok()
{
$MAIL -s "ProScan AntiVirus: update VDF successful" $ADMIN_ADDRESS << EOF

 The update VDF was successful.
 The ProScan AntiVirus daemon has been restarted. 

________________ 
Update Log

$UPDATE_OUT

.
EOF

}

module_update_ok()
{
$MAIL -s "ProScan AntiVirus: update ProScan modeule successful" $ADMIN_ADDRESS << EOF

 The update ProScan modeule was successful.

________________ 
Update Log

$UPDATE_OUT

.
EOF

}

vdf_update_failed()
{
$MAIL -s "ProScan AntiVirus: update VDF failed" $ADMIN_ADDRESS << EOF

 The update process has failed with error level ${RESULT}. 
 Your VDF has not been successfully downloaded 
 the last known good signature database (if one is available).

________________ 
Update Log

$UPDATE_OUT

.
EOF

}

module_update_failed()
{
$MAIL -s "ProScan AntiVirus: update ProScan module failed" $ADMIN_ADDRESS << EOF

 The update process has failed with error level ${RESULT}. 
 ProScan module has not been successfully downloaded 

________________ 
Update Log

$UPDATE_OUT

.
EOF

}

update_not_needed()
{
$MAIL -s "ProScan AntiVirus: update was not needed" $ADMIN_ADDRESS << EOF

 You already have the newest signature database on your system.
 It is not needed to restart the ProScan AntiVirus daemon.
_______________
Update Log

$UPDATE_OUT

.
EOF

}

license_expired()
{
$MAIL -s "ProScan AntiVirus: update license expired" $ADMIN_ADDRESS << EOF

 Your license has already expired.
 Please update the license if you use it continuously.
_______________
Update Log

$UPDATE_OUT

.
EOF

}

update_failed()
{
$MAIL -s "ProScan AntiVirus: update failed" $ADMIN_ADDRESS << EOF

 It failed in the update. 
 Please see to the log file for details. 
_______________
Update Log

$UPDATE_OUT

.
EOF

}

main()
{

UPDATE_OUT="`${PROSCANUPDATE}`"
RESULT=$?

case ${RESULT} in

0)
        FAILED=`echo "$UPDATE_OUT" | grep "failed"`
	VDF_NO_UP=`echo "$UPDATE_OUT" | grep "Nothing to update"`
	#SAVAPI_UP=`echo "$UPDATE_OUT" | grep "Reloading AntiVir: savapi"`
	SAVAPI_OK=`echo "$UPDATE_OUT" | grep "Update finished successfully"`
	RES=`echo "$UPDATE_OUT" | grep "AntiVir update successfully"`
	#PROSCAN_UP=`echo "$UPDATE_OUT" | grep "reloading ProScan modules"`
	PROSCAN_OK=`echo "$UPDATE_OUT" | grep "Installing new ProScan modules successfully"`
	POSTSH_OK=`echo "$UPDATE_OUT" | grep "post_update.sh execute successfully"`
	
	if [ "$FAILED" != "" ]
	then
		if [ $VERBOSE != "silent" ]
		then
			update_failed
		fi
	else
		if [ "$VDF_NO_UP" = "" ]
		then
			if [ "$RES" != "" ]
			then
				if [ $VERBOSE = "noisy" ]
				then
	 				vdf_update_ok
	 				break
	 		    	fi
			else
				if [ $VERBOSE != "silent" ]
				then
					vdf_update_failed
	 				break
				fi
			fi
			if [ "$PROSCAN_OK" != "" -o "$POSTSH_OK" != "" ]
			then
				if [ $VERBOSE = "noisy" ]
				then
	 				module_update_ok
	 		    	fi
			fi
		else
			if [ $VERBOSE = "noisy" ]
			then
				update_not_needed
			fi
		fi
	fi
	;;
99)
	echo "license expired"
	if [ $VERBOSE != "silent" ]; then
		license_expired
	fi
	;;
*)
	echo "update failed"
	if [ $VERBOSE != "silent" ]; then
		update_failed
	fi
	;;
esac

}

main

sleep 5
PROSCAN=/opt/proscan/bin/proscan
PROSCAN_CONF=/etc/opt/proscan/proscan.conf
SOCKET=`grep LocalSocketPath $PROSCAN_CONF|awk -F= '{print $2}'`
SAVAPI_PS=`ps axw|grep /usr/lib/AntiVir/savapi|grep -v grep|grep $SOCKET`
if [ "$SAVAPI_PS" = "" ]
then
    $PROSCAN
fi

exit 0
